<?php
// access.php
// Common Access Control Checker

function get_user_permissions($conn, $role_id, $page_key) {
    $sql = "SELECT can_view, can_add, can_edit
            FROM role_permissions
            WHERE role_id = $role_id 
            AND page_key = '$page_key'
            LIMIT 1";

    $res = $conn->query($sql);
    return $res ? $res->fetch_assoc() : ["can_view" => 0, "can_add" => 0, "can_edit" => 0];
}

/*
---------------------------------------------------------------
 check_access($conn, $user_role_id, $page_key, $required)
---------------------------------------------------------------
 $required options:
   "view"  → Must have can_view = 1
   "add"   → Must have can_add  = 1
   "edit"  → Must have can_edit = 1
---------------------------------------------------------------
*/
function check_access($conn, $user_role_id, $page_key, $required) {

    $perm = get_user_permissions($conn, $user_role_id, $page_key);

    if ($required === "view" && $perm["can_view"] != 1) {
        send_no_access("view");
    }

    if ($required === "add" && $perm["can_add"] != 1) {
        send_no_access("add");
    }

    if ($required === "edit" && $perm["can_edit"] != 1) {
        send_no_access("edit");
    }

    return true; // access allowed
}

// Standard error response
function send_no_access($type) {
    http_response_code(403);
    echo json_encode([
        "status" => "error",
        "message" => "You do not have permission to $type this page"
    ]);
    exit;
}
?>
