<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../db/db.php';
require_once __DIR__ . '/../jwt_utils/jwt_utils.php';

header("Content-Type: application/json");

// -----------------------------------------
// JWT AUTH CHECK
// -----------------------------------------
$headers = getallheaders();

if (empty($headers['Authorization'])) {
    http_response_code(401);
    echo json_encode(["error" => "No token"]);
    exit;
}

$jwt = str_replace("Bearer ", "", $headers['Authorization']);
$payload = validate_jwt($jwt, $jwt_secret);

if (!$payload || !isset($payload['id'])) {
    http_response_code(401);
    echo json_encode(["error" => "Invalid token"]);
    exit;
}

require_once __DIR__ . '/access.php';

$current_user_id = intval($payload["id"]);
// IMPORTANT: Fetch user's role_id from JWT
$current_role_id = intval($payload["role_id"]);
// ------------------------------------------------------------------
// ACTION ROUTER
// ------------------------------------------------------------------
$action = $_GET['action'] ?? '';

switch ($action) {

    case 'mark':
        markAttendance($conn, $current_user_id);
        break;

    case 'list':
        listAttendance($conn);
        break;

    default:
        echo json_encode(["error" => "Invalid action"]);
        break;
}


/* ==========================================================
   FUNCTIONS
   ========================================================== */


// ---------------------------------------------------------
// MARK ATTENDANCE (QR scan)
// ---------------------------------------------------------
function markAttendance($conn, $user_id)
{
    $input = json_decode(file_get_contents("php://input"), true);

    if (empty($input['meeting_id'])) {
        echo json_encode(["error" => "meeting_id required"]);
        exit;
    }

    $meeting_id = intval($input['meeting_id']);
    $member_id = intval($user_id); // from JWT

    // -----------------------------------------------------
    // CHECK IF ALREADY MARKED
    // -----------------------------------------------------
    $stmt = $conn->prepare("
        SELECT id 
        FROM meeting_attendance 
        WHERE meeting_id = ? AND member_id = ?
        LIMIT 1
    ");
    $stmt->bind_param("ii", $meeting_id, $member_id);
    $stmt->execute();
    $exists = $stmt->get_result()->fetch_assoc();
    $stmt->close();

    if ($exists) {
        echo json_encode(["error" => "Already marked"]);
        exit;
    }

    // -----------------------------------------------------
    // INSERT ATTENDANCE RECORD
    // -----------------------------------------------------
    $stmt = $conn->prepare("
        INSERT INTO meeting_attendance (meeting_id, member_id, qr_scan_time)
        VALUES (?, ?, NOW())
    ");
    $stmt->bind_param("ii", $meeting_id, $member_id);

    if ($stmt->execute()) {
        echo json_encode([
            "success" => true,
            "message" => "Attendance marked"
        ]);
    } else {
        echo json_encode(["error" => "Failed to mark attendance"]);
    }

    $stmt->close();
    exit;
}



// ---------------------------------------------------------
// LIST ATTENDANCE (Admin view)
// ---------------------------------------------------------
function listAttendance($conn)
{
    if (empty($_GET['meeting_id'])) {
        echo json_encode(["error" => "meeting_id required"]);
        exit;
    }

    $meeting_id = intval($_GET['meeting_id']);

    $stmt = $conn->prepare("
        SELECT 
            a.id,
            a.meeting_id,
            a.member_id,
            a.qr_scan_time,
            m.name AS member_name,
            m.email AS member_email
        FROM meeting_attendance a
        JOIN members m ON m.id = a.member_id
        WHERE a.meeting_id = ?
        ORDER BY a.qr_scan_time ASC
    ");
    $stmt->bind_param("i", $meeting_id);
    $stmt->execute();

    $res = $stmt->get_result();
    $data = [];

    while ($row = $res->fetch_assoc()) {
        $data[] = $row;
    }

    echo json_encode([
        "success" => true,
        "attendance" => $data
    ]);
    exit;
}

?>
