<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Content-Type: application/json");

// Handle OPTIONS preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}
?>

<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../db/db.php';
require_once __DIR__ . '/../jwt_utils/jwt_utils.php';

header('Content-Type: application/json');

// LOGIN (using main phone number)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_GET['action'] ?? '') === 'login') {
    $data = json_decode(file_get_contents("php://input"), true);
    $phone = $conn->real_escape_string($data['phone'] ?? '');
    $password = $data['password'] ?? '';

    $sql =
        "SELECT m.*, mr.role_id
         FROM members m
         JOIN member_phones mp ON mp.member_id = m.id
         join members_roles mr on mr.member_id = m.id
         WHERE mp.phone_number = '$phone'
           AND mp.is_main = 1
         LIMIT 1";
    $result = $conn->query($sql);

    if ($row = $result->fetch_assoc()) {
        if (password_verify($password, $row['password'])) {
            $payload = [
                "id" => $row['id'],
                "name" => $row['name'],
                "main_phone" => $phone,
                "role_id" => $row['role_id'],
                "exp" => time() + 3600 // Token valid for 1 hour
            ];
            $jwt = create_jwt($payload, $jwt_secret);
                // Build user data for frontend
    $userData = [
        "name" => $row['name'],
        "profile_pic" => $row['profile_pic'] ?? "" // assuming column name profile_pic
    ];

    echo json_encode([
        "token" => $jwt,
        "user" => $userData
    ]);
        } else {
            echo json_encode(["error" => "Invalid credentials"]);
        }
    } else {
        echo json_encode(["error" => "User not found with main phone"]);
    }
    exit;
}

// REGISTRATION (add phone and member with password)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_GET['action'] ?? '') === 'register') {
    file_put_contents("debug_register.txt", file_get_contents("php://input"));
    $data = json_decode(file_get_contents("php://input"), true);
    $name = $conn->real_escape_string($data['name'] ?? '');
    $phone = $conn->real_escape_string($data['phone'] ?? '');
    $password = password_hash($data['password'] ?? '', PASSWORD_BCRYPT);

    $conn->begin_transaction();
    try {
        // Add member
        $sql = "INSERT INTO members (name, password) VALUES ('$name', '$password');";
        if (!$conn->query($sql)) throw new Exception($conn->error);

        $member_id = $conn->insert_id;

        // Add main phone record
        $sql = "INSERT INTO member_phones (member_id, phone_number, type, is_main)
                VALUES ($member_id, '$phone', 'Mobile', 1);";
        if (!$conn->query($sql)) throw new Exception($conn->error);

        $conn->commit();
        echo json_encode(["success" => true, "member_id" => $member_id]);
    } catch (Exception $e) {
        $conn->rollback();
        file_put_contents("register_error_log.txt", $e->getMessage());
        echo json_encode(["error" => $e->getMessage()]);
    }
    exit;
}

http_response_code(400);
echo json_encode(["error" => "Invalid request"]);
?>
