<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../db/db.php';

header("Content-Type: application/json");

$input = json_decode(file_get_contents("php://input"), true);

$phone = $conn->real_escape_string($input["phone"] ?? "");
$otp = $conn->real_escape_string($input["otp"] ?? "");
$password = $conn->real_escape_string($input["password"] ?? "");

if ($phone === "" || $otp === "" || $password === "") {
    echo json_encode(["error" => "Missing fields"]);
    exit;
}

$res = $conn->query("
    SELECT otp, expiry 
    FROM password_otps 
    WHERE phone='$phone' 
    ORDER BY id DESC 
    LIMIT 1
");

if ($res->num_rows === 0) {
    echo json_encode(["error" => "OTP not found"]);
    exit;
}

$row = $res->fetch_assoc();

if ($row["otp"] != $otp) {
    echo json_encode(["error" => "Invalid OTP"]);
    exit;
}

if (strtotime($row["expiry"]) < time()) {
    echo json_encode(["error" => "OTP expired"]);
    exit;
}

// UPDATE PASSWORD
$hashed = password_hash($password, PASSWORD_BCRYPT);

// Find member via phone
$m = $conn->query("
    SELECT member_id 
    FROM member_phones 
    WHERE phone_number='$phone'
    LIMIT 1
")->fetch_assoc();

$member_id = $m["member_id"];

$conn->query("UPDATE members SET password='$hashed' WHERE id=$member_id");

// Delete OTP
$conn->query("DELETE FROM password_otps WHERE phone='$phone'");

echo json_encode(["success" => true]);
?>
