<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../db/db.php';
require_once __DIR__ . '/../jwt_utils/jwt_utils.php';

header("Content-Type: application/json");

// -----------------------------------------
// JWT AUTH
// -----------------------------------------
$headers = getallheaders();

if (empty($headers['Authorization'])) {
    http_response_code(401);
    echo json_encode(["error" => "No token"]);
    exit;
}

$jwt = str_replace("Bearer ", "", $headers['Authorization']);
$payload = validate_jwt($jwt, $jwt_secret);

if (!$payload) {
    http_response_code(401);
    echo json_encode(["error" => "Invalid token"]);
    exit;
}

// -----------------------------------------
// ACTION HANDLER
// -----------------------------------------
$action = $_GET['action'] ?? '';

switch ($action) {
    case 'get_calendar':
        getCalendarData($conn);
        break;

    default:
        echo json_encode(["error" => "Invalid action"]);
        break;
}


/* =======================================================
   FUNCTIONS
   ======================================================= */

function getCalendarData($conn)
{
    $output = [
        "status" => true,
        "bookings" => [],
        "meetings" => []
    ];

    // -----------------------------------------------------
    // BOOKING (type = external)
    // -----------------------------------------------------
    $q1 = "SELECT id, booked_by, purpose, start_time, end_time, status, type
           FROM bookings 
           WHERE type = 'external'
           ORDER BY start_time ASC";

    $r1 = $conn->query($q1);

    while ($row = $r1->fetch_assoc()) {
        $output["bookings"][] = $row;
    }

    // -----------------------------------------------------
    // MEETING (type = internal)
    // -----------------------------------------------------
    $q2 = "SELECT id, booked_by, purpose, start_time, end_time, status, type
           FROM bookings 
           WHERE type = 'internal'
           ORDER BY start_time ASC";

    $r2 = $conn->query($q2);

    while ($row = $r2->fetch_assoc()) {
        $output["meetings"][] = $row;
    }

    echo json_encode($output);
    exit;
}

?>
