<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../db/db.php';
require_once __DIR__ . '/../jwt_utils/jwt_utils.php';

header("Content-Type: application/json");

// -----------------------------------------
// OLD JWT AUTH CHECK (MATCH SLOT.PHP)
// -----------------------------------------
$headers = getallheaders();

if (empty($headers['Authorization'])) {
    http_response_code(401);
    echo json_encode(["error" => "No token provided"]);
    exit;
}

$jwt = str_replace("Bearer ", "", $headers["Authorization"]);

// USE OLD JWT METHOD
$payload = validate_jwt($jwt, $jwt_secret);

if (!$payload || !isset($payload["id"])) {
    http_response_code(401);
    echo json_encode(["error" => "Invalid token"]);
    exit;
}

$current_user_id = intval($payload["id"]);

// -----------------------------------------
// ACTION
// -----------------------------------------
$action = $_GET['action'] ?? $_POST['action'] ?? "";

// Helper function
function runQuery($conn, $query, $params = [])
{
    $stmt = $conn->prepare($query);
    if ($params) {
        $types = str_repeat("s", count($params));
        $stmt->bind_param($types, ...$params);
    }
    $stmt->execute();
    return $stmt;
}

// -----------------------------------------
// GET INCOME CATEGORIES
// -----------------------------------------
if ($action === "get_income") {

    $res = runQuery($conn, "SELECT id, category_name FROM income_categories ORDER BY id DESC");
    $data = $res->get_result()->fetch_all(MYSQLI_ASSOC);

    echo json_encode($data);
    exit;
}

// -----------------------------------------
// GET EXPENSE CATEGORIES
// -----------------------------------------
if ($action === "get_expense") {

    $res = runQuery($conn, "SELECT id, category_name FROM expense_categories ORDER BY id DESC");
    $data = $res->get_result()->fetch_all(MYSQLI_ASSOC);

    echo json_encode($data);
    exit;
}

// -----------------------------------------
// SAVE CATEGORY (ADD / EDIT)
// -----------------------------------------
if ($action === "save") {

    $id   = $_POST["id"] ?? "";
    $name = $_POST["category_name"] ?? "";
    $type = $_POST["type"] ?? "";  // income | expense

    if (!in_array($type, ["income", "expense"])) {
        echo json_encode(["status" => false, "message" => "Invalid category type"]);
        exit;
    }

    $table = $type . "_categories";

    if ($id == "") {
        // ADD
        runQuery($conn, "INSERT INTO $table (category_name) VALUES (?)", [$name]);
        echo json_encode(["status" => true, "message" => "Category added"]);
    } else {
        // UPDATE
        runQuery($conn, "UPDATE $table SET category_name=? WHERE id=?", [$name, $id]);
        echo json_encode(["status" => true, "message" => "Category updated"]);
    }

    exit;
}

// -----------------------------------------
// DELETE CATEGORY
// -----------------------------------------
if ($action === "delete") {

    $id   = $_GET["id"] ?? "";
    $type = $_GET["type"] ?? "";

    if (!$id || !in_array($type, ["income", "expense"])) {
        echo json_encode(["status" => false, "message" => "Invalid delete params"]);
        exit;
    }

    $table = $type . "_categories";

    runQuery($conn, "DELETE FROM $table WHERE id=?", [$id]);

    echo json_encode(["status" => true, "message" => "Category deleted"]);
    exit;
}

// -----------------------------------------
// INVALID ACTION
// -----------------------------------------
echo json_encode(["status" => false, "message" => "Invalid action"]);
exit;
?>
