<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../db/db.php';
require_once __DIR__ . '/../jwt_utils/jwt_utils.php';

header("Content-Type: application/json");

// ----------------------------------
// JWT Auth
// ----------------------------------
$headers = getallheaders();
if (empty($headers['Authorization'])) {
    http_response_code(401);
    echo json_encode(["error" => "No token"]);
    exit;
}

$jwt = str_replace("Bearer ", "", $headers["Authorization"]);
$payload = validate_jwt($jwt, $jwt_secret);
if (!$payload) {
    http_response_code(401);
    echo json_encode(["error" => "Invalid token"]);
    exit;
}

// ----------------------------------
// Inputs
// ----------------------------------
$date = $_POST['date'] ?? null;
$slot = intval($_POST['slot'] ?? 0);
$start = $_POST['start_time'] ?? null;

if (!$date || !$start || !$slot) {
    echo json_encode(["error" => "Missing fields"]);
    exit;
}

// Calculate real start & end datetimes
$start_dt = "$date $start";
$end_dt = date("Y-m-d H:i:s", strtotime("$start_dt +$slot hours"));

// Buffer times (1 hour)
$start_with_buffer = date("Y-m-d H:i:s", strtotime("$start_dt -1 hour"));
$end_with_buffer   = date("Y-m-d H:i:s", strtotime("$end_dt +1 hour"));

$sql = "SELECT id, purpose, start_time, end_time 
        FROM bookings
        WHERE DATE(start_time)=?
        AND status='booked'
        AND (
            start_time < ?   -- existing starts before new end + buffer
            AND 
            end_time  > ?   -- existing ends after new start - buffer
        )";

$stmt = $conn->prepare($sql);
$stmt->bind_param("sss", $date, $end_with_buffer, $start_with_buffer);
$stmt->execute();
$res = $stmt->get_result();


if ($row = $res->fetch_assoc()) {
    echo json_encode([
        "available" => false,
        "details" => $row['purpose'] . " (" . $row['start_time'] . " - " . $row['end_time'] . ")"
    ]);
} else {
    echo json_encode([
        "available" => true
    ]);
}
exit;
?>
