<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../db/db.php';
require_once __DIR__ . '/../jwt_utils/jwt_utils.php';

header("Content-Type: application/json");

// ---------------------------
// JWT AUTH
// ---------------------------
$headers = getallheaders();

if (empty($headers["Authorization"])) {
    http_response_code(401);
    echo json_encode(["error" => "No token"]);
    exit;
}

$jwt = str_replace("Bearer ", "", $headers["Authorization"]);
$payload = validate_jwt($jwt, $jwt_secret);

if (!$payload || !isset($payload["id"])) {
    http_response_code(401);
    echo json_encode(["error" => "Invalid token"]);
    exit;
}

// ---------------------------
// ACTION HANDLER
// ---------------------------
$action = $_GET["action"] ?? "";

switch ($action) {
    case "get_stats":
        getDashboardStats($conn);
        break;

    default:
        echo json_encode(["error" => "Invalid action"]);
        break;
}


/* =======================================================
   GET DASHBOARD STATS
   ======================================================= */
function getDashboardStats($conn)
{
    $out = [
        "total_members"     => 0,
        "upcoming_meetings" => 0,
        "active_bookings"   => 0,
        "month_revenue"     => 0
    ];

    // ---------------------------------------
    // TOTAL MEMBERS
    // ---------------------------------------
    $q = $conn->query("SELECT COUNT(*) AS c FROM members");
    $r = $q->fetch_assoc();
    $out["total_members"] = intval($r["c"]);

    // ---------------------------------------
    // UPCOMING MEETINGS (type = internal)
    // ---------------------------------------
    $q = $conn->query("
        SELECT COUNT(*) AS c 
        FROM bookings 
        WHERE type='internal' 
          AND status='booked'
          AND start_time >= NOW()
    ");

    $r = $q->fetch_assoc();
    $out["upcoming_meetings"] = intval($r["c"]);

    // ---------------------------------------
    // ACTIVE BOOKINGS (type = external)
    // ---------------------------------------
    $q = $conn->query("
        SELECT COUNT(*) AS c 
        FROM bookings 
        WHERE type='external'
          AND status='booked'
    ");

    $r = $q->fetch_assoc();
    $out["active_bookings"] = intval($r["c"]);

    // ---------------------------------------
    // MONTH REVENUE
    // booking_payments + income - expenses
    // ---------------------------------------

    // 1️⃣ Booking Payments (Actual cash received)
    $q = $conn->query("
        SELECT IFNULL(SUM(amount),0) AS total
        FROM booking_payments
        WHERE MONTH(paid_at) = MONTH(CURRENT_DATE())
        AND YEAR(paid_at)  = YEAR(CURRENT_DATE())
    ");
    $r = $q->fetch_assoc();
    $bookingPayments = floatval($r["total"] ?? 0);

    // 2️⃣ Other Income
    $q = $conn->query("
        SELECT IFNULL(SUM(amount),0) AS total
        FROM incomes
        WHERE MONTH(income_date) = MONTH(CURRENT_DATE())
        AND YEAR(income_date)  = YEAR(CURRENT_DATE())
    ");
    $r = $q->fetch_assoc();
    $otherIncome = floatval($r["total"] ?? 0);

    // 3️⃣ Expenses
    $q = $conn->query("
        SELECT IFNULL(SUM(amount),0) AS total
        FROM expenses
        WHERE MONTH(expense_date) = MONTH(CURRENT_DATE())
        AND YEAR(expense_date)  = YEAR(CURRENT_DATE())
    ");
    $r = $q->fetch_assoc();
    $expenses = floatval($r["total"] ?? 0);

    // 4️⃣ Final Revenue
    $out["month_revenue"] = $bookingPayments + $otherIncome - $expenses;


    echo json_encode($out);
    exit;
}
?>
