<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../db/db.php';
require_once __DIR__ . '/../jwt_utils/jwt_utils.php';

header('Content-Type: application/json');
$headers = getallheaders();
$method = $_SERVER['REQUEST_METHOD'];

// JWT Auth
if (empty($headers['Authorization'])) {
    http_response_code(401);
    echo json_encode(['error' => 'No token!']); exit;
}
$jwt = str_replace('Bearer ', '', $headers['Authorization']);
$payload = validate_jwt($jwt, $jwt_secret);
if (!$payload || !isset($payload['id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Invalid token!']); exit;
}
$user_id = intval($payload['id']);

// ----- Add Expense -----
if ($method === 'POST' && !isset($_GET['expense_id'])) {
    $input = json_decode(file_get_contents("php://input"), true);
    $category_id = intval($input['category_id']);
    $amount = floatval($input['amount']);
    $desc = $conn->real_escape_string($input['description'] ?? '');
    $expense_date = $conn->real_escape_string($input['expense_date'] ?? date('Y-m-d'));

    $sql = "INSERT INTO expenses (category_id, amount, description, expense_date, recorded_by, created_at)
            VALUES ($category_id, $amount, '$desc', '$expense_date', $user_id, NOW())";
    if ($conn->query($sql)) {
        echo json_encode(['success' => true, 'expense_id' => $conn->insert_id]);
    } else {
        echo json_encode(['error' => $conn->error]);
    }
    exit;
}

// ----- List Expenses -----
if ($method === 'GET' && !isset($_GET['expense_id'])) {
    $where = [];
    if (isset($_GET['category_id'])) $where[] = 'category_id=' . intval($_GET['category_id']);
    if (isset($_GET['user_id'])) $where[] = 'recorded_by=' . intval($_GET['user_id']);
    if (isset($_GET['from'])) $where[] = "expense_date >= '" . $conn->real_escape_string($_GET['from']) . "'";
    if (isset($_GET['to'])) $where[] = "expense_date <= '" . $conn->real_escape_string($_GET['to']) . "'";
    $where_sql = $where ? ('WHERE ' . implode(' AND ', $where)) : '';

    $sql = "SELECT e.*, ec.category_name, m.name AS member_name 
            FROM expenses e
            LEFT JOIN expense_categories ec ON e.category_id = ec.id
            LEFT JOIN members m ON e.recorded_by = m.id
            $where_sql
            ORDER BY e.expense_date DESC";
    $result = $conn->query($sql);
    $expenses = [];
    while ($row = $result->fetch_assoc()) {
        $expenses[] = $row;
    }
    echo json_encode($expenses);
    exit;
}

// ----- Get One Expense -----
if ($method === 'GET' && isset($_GET['expense_id'])) {
    $expense_id = intval($_GET['expense_id']);
    $sql = "SELECT e.*, ec.category_name, m.name AS member_name 
            FROM expenses e
            LEFT JOIN expense_categories ec ON e.category_id = ec.id
            LEFT JOIN members m ON e.recorded_by = m.id
            WHERE e.id = $expense_id";
    $result = $conn->query($sql);
    if ($row = $result->fetch_assoc()) {
        echo json_encode($row);
    } else {
        echo json_encode(['error' => 'Expense not found']);
    }
    exit;
}

// ----- Update Expense -----
if ($method === 'PUT' && isset($_GET['expense_id'])) {
    $expense_id = intval($_GET['expense_id']);
    $input = json_decode(file_get_contents("php://input"), true);
    $category_id = intval($input['category_id'] ?? 0);
    $amount = floatval($input['amount'] ?? 0);
    $desc = $conn->real_escape_string($input['description'] ?? '');
    $expense_date = $conn->real_escape_string($input['expense_date'] ?? '');

    // Only creator or admin (extend with proper role check)
    $check_sql = "SELECT recorded_by FROM expenses WHERE id = $expense_id";
    $check_result = $conn->query($check_sql);
    if ($check_row = $check_result->fetch_assoc()) {
        if ($check_row['recorded_by'] != $user_id) {
            echo json_encode(['error' => 'Not authorized']); exit;
        }
    } else {
        echo json_encode(['error' => 'Expense not found']); exit;
    }

    $sql = "UPDATE expenses SET category_id=$category_id, amount=$amount, description='$desc', expense_date='$expense_date' WHERE id=$expense_id";
    if ($conn->query($sql)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['error' => $conn->error]);
    }
    exit;
}

// ----- Delete Expense -----
if ($method === 'DELETE' && isset($_GET['expense_id'])) {
    $expense_id = intval($_GET['expense_id']);
    // Only creator or admin (extend with proper role check)
    $check_sql = "SELECT recorded_by FROM expenses WHERE id = $expense_id";
    $check_result = $conn->query($check_sql);
    if ($check_row = $check_result->fetch_assoc()) {
        if ($check_row['recorded_by'] != $user_id) {
            echo json_encode(['error' => 'Not authorized']); exit;
        }
    } else {
        echo json_encode(['error' => 'Expense not found']); exit;
    }
    $sql = "DELETE FROM expenses WHERE id=$expense_id";
    if ($conn->query($sql)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['error' => $conn->error]);
    }
    exit;
}

// ----- Expense Categories (List) -----
if ($method === 'GET' && isset($_GET['categories'])) {
    $sql = "SELECT * FROM expense_categories ORDER BY category_name";
    $result = $conn->query($sql);
    $categories = [];
    while ($row = $result->fetch_assoc()) {
        $categories[] = $row;
    }
    echo json_encode($categories);
    exit;
}

// ----- Add Expense Category -----
if ($method === 'POST' && isset($_GET['categories'])) {
    $input = json_decode(file_get_contents("php://input"), true);
    $category_name = $conn->real_escape_string($input['category_name'] ?? '');
    if (!$category_name) {
        echo json_encode(['error' => 'Category name required']); exit;
    }
    $sql = "INSERT INTO expense_categories (category_name) VALUES ('$category_name')";
    if ($conn->query($sql)) {
        echo json_encode(['success' => true, 'category_id' => $conn->insert_id]);
    } else {
        echo json_encode(['error' => $conn->error]);
    }
    exit;
}

// --- If No Matching Route ---
http_response_code(400);
echo json_encode(['error' => 'Invalid request']);
?>
