<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../db/db.php';
require_once __DIR__ . '/../jwt_utils/jwt_utils.php';

header('Content-Type: application/json');
$headers = getallheaders();
$method = $_SERVER['REQUEST_METHOD'];

// JWT Authentication
if (empty($headers['Authorization'])) {
    http_response_code(401);
    echo json_encode(['error' => 'No token!']); exit;
}
$jwt = str_replace('Bearer ', '', $headers['Authorization']);
$payload = validate_jwt($jwt, $jwt_secret);
if (!$payload || !isset($payload['id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Invalid token!']); exit;
}
$member_id = intval($payload['id']);

// ---- CREATE Family Member ----
if ($method === 'POST' && !isset($_GET['family_id'])) {
    $input = json_decode(file_get_contents("php://input"), true);
    $name = $conn->real_escape_string($input['name'] ?? '');
    $relation = $conn->real_escape_string($input['relation'] ?? null);
    $dob = $conn->real_escape_string($input['dob'] ?? null);
    $notes = $conn->real_escape_string($input['notes'] ?? '');

    $sql = "INSERT INTO member_family (member_id, name, relation, dob, notes)
            VALUES ($member_id, '$name', '$relation', '$dob', '$notes')";
    if ($conn->query($sql)) {
        echo json_encode(['success' => true, 'id' => $conn->insert_id]);
    } else {
        echo json_encode(['error' => $conn->error]);
    }
    exit;
}

// ---- READ ALL Family Members ----
if ($method === 'GET' && !isset($_GET['family_id'])) {
    $sql = "SELECT * FROM member_family WHERE member_id = $member_id";
    $result = $conn->query($sql);
    $family = [];
    while ($row = $result->fetch_assoc()) {
        // Fetch phones for each family member
        $fid = intval($row['id']);
        $phones_sql = "SELECT id, phone_number, type FROM family_member_phones WHERE family_member_id = $fid";
        $phones_result = $conn->query($phones_sql);
        $phones = [];
        while ($p = $phones_result->fetch_assoc()) {
            $phones[] = $p;
        }
        $row['phones'] = $phones;
        $family[] = $row;
    }
    echo json_encode($family);
    exit;
}

// ---- READ ONE Family Member (by family_id) ----
if ($method === 'GET' && isset($_GET['family_id'])) {
    $fid = intval($_GET['family_id']);
    $sql = "SELECT * FROM member_family WHERE id = $fid AND member_id = $member_id";
    $result = $conn->query($sql);
    if ($row = $result->fetch_assoc()) {
        $phones_sql = "SELECT id, phone_number, type FROM family_member_phones WHERE family_member_id = $fid";
        $phones_result = $conn->query($phones_sql);
        $phones = [];
        while ($p = $phones_result->fetch_assoc()) {
            $phones[] = $p;
        }
        $row['phones'] = $phones;
        echo json_encode($row);
    } else {
        echo json_encode(['error' => 'Family member not found']);
    }
    exit;
}

// ---- UPDATE Family Member ----
if ($method === 'PUT' && isset($_GET['family_id'])) {
    $fid = intval($_GET['family_id']);
    $input = json_decode(file_get_contents("php://input"), true);
    $name = $conn->real_escape_string($input['name'] ?? '');
    $relation = $conn->real_escape_string($input['relation'] ?? '');
    $dob = $conn->real_escape_string($input['dob'] ?? null);
    $notes = $conn->real_escape_string($input['notes'] ?? '');

    $sql = "UPDATE member_family SET name='$name', relation='$relation', dob='$dob', notes='$notes'
            WHERE id=$fid AND member_id=$member_id";
    if ($conn->query($sql)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['error' => $conn->error]);
    }
    exit;
}

// ---- DELETE Family Member ----
if ($method === 'DELETE' && isset($_GET['family_id'])) {
    $fid = intval($_GET['family_id']);
    $sql = "DELETE FROM member_family WHERE id=$fid AND member_id=$member_id";
    if ($conn->query($sql)) {
        // Phones are deleted by ON DELETE CASCADE
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['error' => $conn->error]);
    }
    exit;
}

// ---- CREATE Phone for Family Member ----
if ($method === 'POST' && isset($_GET['family_id']) && isset($_GET['phone'])) {
    $fid = intval($_GET['family_id']);
    $input = json_decode(file_get_contents("php://input"), true);
    $phone_number = $conn->real_escape_string($input['phone_number'] ?? '');
    $type = $conn->real_escape_string($input['type'] ?? '');

    // Ensure family member exists & belongs to requesting user
    $fam_sql = "SELECT id FROM member_family WHERE id = $fid AND member_id = $member_id";
    $fam_result = $conn->query($fam_sql);
    if (!$fam_result->fetch_assoc()) {
        echo json_encode(['error' => 'Not authorized']); exit;
    }

    $sql = "INSERT INTO family_member_phones (family_member_id, phone_number, type)
            VALUES ($fid, '$phone_number', '$type')";
    if ($conn->query($sql)) {
        echo json_encode(['success' => true, 'id' => $conn->insert_id]);
    } else {
        echo json_encode(['error' => $conn->error]);
    }
    exit;
}

// ---- DELETE Phone from Family Member ----
if ($method === 'DELETE' && isset($_GET['phone_id'])) {
    $pid = intval($_GET['phone_id']);
    // To be safe, join with member_family to ensure it's user's family member
    $sql = "DELETE fmp FROM family_member_phones fmp
            INNER JOIN member_family mf ON fmp.family_member_id = mf.id
            WHERE fmp.id = $pid AND mf.member_id = $member_id";
    if ($conn->query($sql)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['error' => $conn->error]);
    }
    exit;
}

// --- If No Matching Route ---
http_response_code(400);
echo json_encode(['error' => 'Invalid request']);
?>
