<?php
header("Content-Type: application/json");

if (!isset($_GET['id'])) {
    echo json_encode(["success" => false, "error" => "Meeting ID missing"]);
    exit;
}

$meetingId = intval($_GET['id']);

// Text encoded inside QR
$qrText = "MEETING-ID:" . $meetingId;

// Path to phpqrcode
require_once __DIR__ . '/../libs/phpqrcode/qrlib.php';

// QR folder path
$qrFolder = __DIR__ . '/../qr/';
if (!file_exists($qrFolder)) {
    mkdir($qrFolder, 0777, true);
}

$fileName = "meeting_" . $meetingId . ".png";
$filePath = $qrFolder . $fileName;

// Generate QR
QRcode::png($qrText, $filePath, QR_ECLEVEL_L, 6);

echo json_encode([
    "success" => true,
    "qr_url" => "/qr/" . $fileName
]);
