<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../db/db.php';
require_once __DIR__ . '/../jwt_utils/jwt_utils.php';

header('Content-Type: application/json');
$headers = getallheaders();
$method = $_SERVER['REQUEST_METHOD'];

// JWT Auth
if (empty($headers['Authorization'])) {
    http_response_code(401);
    echo json_encode(['error' => 'No token!']); exit;
}
$jwt = str_replace('Bearer ', '', $headers['Authorization']);
$payload = validate_jwt($jwt, $jwt_secret);
if (!$payload || !isset($payload['id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Invalid token!']); exit;
}
$user_id = intval($payload['id']);

// ----- Add Income -----
if ($method === 'POST' && !isset($_GET['income_id'])) {
    $input = json_decode(file_get_contents("php://input"), true);
    $category_id = intval($input['category_id']);
    $amount = floatval($input['amount']);
    $description = $conn->real_escape_string($input['description'] ?? '');
    $income_date = $conn->real_escape_string($input['income_date'] ?? date('Y-m-d'));
    
    $sql = "INSERT INTO incomes (category_id, amount, description, income_date, recorded_by, created_at)
            VALUES ($category_id, $amount, '$description', '$income_date', $user_id, NOW())";
    if ($conn->query($sql)) {
        echo json_encode(['success' => true, 'income_id' => $conn->insert_id]);
    } else {
        echo json_encode(['error' => $conn->error]);
    }
    exit;
}

// ----- List Incomes -----
if ($method === 'GET' && !isset($_GET['income_id'])) {
    $where = [];
    if (isset($_GET['category_id'])) $where[] = 'category_id=' . intval($_GET['category_id']);
    if (isset($_GET['user_id'])) $where[] = 'recorded_by=' . intval($_GET['user_id']);
    if (isset($_GET['from'])) $where[] = "income_date >= '" . $conn->real_escape_string($_GET['from']) . "'";
    if (isset($_GET['to'])) $where[] = "income_date <= '" . $conn->real_escape_string($_GET['to']) . "'";
    $where_sql = $where ? ('WHERE ' . implode(' AND ', $where)) : '';

    $sql = "SELECT i.*, ic.category_name, m.name AS member_name 
            FROM incomes i
            LEFT JOIN income_categories ic ON i.category_id = ic.id
            LEFT JOIN members m ON i.recorded_by = m.id
            $where_sql
            ORDER BY i.income_date DESC";
    $result = $conn->query($sql);
    $incomes = [];
    while ($row = $result->fetch_assoc()) {
        $incomes[] = $row;
    }
    echo json_encode($incomes);
    exit;
}

// ----- Get One Income -----
if ($method === 'GET' && isset($_GET['income_id'])) {
    $income_id = intval($_GET['income_id']);
    $sql = "SELECT i.*, ic.category_name, m.name AS member_name 
            FROM incomes i
            LEFT JOIN income_categories ic ON i.category_id = ic.id
            LEFT JOIN members m ON i.recorded_by = m.id
            WHERE i.id = $income_id";
    $result = $conn->query($sql);
    if ($row = $result->fetch_assoc()) {
        echo json_encode($row);
    } else {
        echo json_encode(['error' => 'Income not found']);
    }
    exit;
}

// ----- Update Income -----
if ($method === 'PUT' && isset($_GET['income_id'])) {
    $income_id = intval($_GET['income_id']);
    $input = json_decode(file_get_contents("php://input"), true);
    $category_id = intval($input['category_id'] ?? 0);
    $amount = floatval($input['amount'] ?? 0);
    $description = $conn->real_escape_string($input['description'] ?? '');
    $income_date = $conn->real_escape_string($input['income_date'] ?? '');

    // Only creator or admin (extend properly for roles)
    $check_sql = "SELECT recorded_by FROM incomes WHERE id = $income_id";
    $check_result = $conn->query($check_sql);
    if ($check_row = $check_result->fetch_assoc()) {
        if ($check_row['recorded_by'] != $user_id) {
            echo json_encode(['error' => 'Not authorized']); exit;
        }
    } else {
        echo json_encode(['error' => 'Income not found']); exit;
    }

    $sql = "UPDATE incomes SET category_id=$category_id, amount=$amount, description='$description', income_date='$income_date' WHERE id=$income_id";
    if ($conn->query($sql)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['error' => $conn->error]);
    }
    exit;
}

// ----- Delete Income -----
if ($method === 'DELETE' && isset($_GET['income_id'])) {
    $income_id = intval($_GET['income_id']);
    // Only creator or admin (extend properly for roles)
    $check_sql = "SELECT recorded_by FROM incomes WHERE id = $income_id";
    $check_result = $conn->query($check_sql);
    if ($check_row = $check_result->fetch_assoc()) {
        if ($check_row['recorded_by'] != $user_id) {
            echo json_encode(['error' => 'Not authorized']); exit;
        }
    } else {
        echo json_encode(['error' => 'Income not found']); exit;
    }
    $sql = "DELETE FROM incomes WHERE id=$income_id";
    if ($conn->query($sql)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['error' => $conn->error]);
    }
    exit;
}

// ----- Income Categories (List) -----
if ($method === 'GET' && isset($_GET['categories'])) {
    $sql = "SELECT * FROM income_categories ORDER BY category_name";
    $result = $conn->query($sql);
    $categories = [];
    while ($row = $result->fetch_assoc()) {
        $categories[] = $row;
    }
    echo json_encode($categories);
    exit;
}

// ----- Add Income Category -----
if ($method === 'POST' && isset($_GET['categories'])) {
    $input = json_decode(file_get_contents("php://input"), true);
    $category_name = $conn->real_escape_string($input['category_name'] ?? '');
    if (!$category_name) {
        echo json_encode(['error' => 'Category name required']); exit;
    }
    $sql = "INSERT INTO income_categories (category_name) VALUES ('$category_name')";
    if ($conn->query($sql)) {
        echo json_encode(['success' => true, 'category_id' => $conn->insert_id]);
    } else {
        echo json_encode(['error' => $conn->error]);
    }
    exit;
}

// --- If No Matching Route ---
http_response_code(400);
echo json_encode(['error' => 'Invalid request']);

?>
