<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, OPTIONS");
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(200); exit(); }

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../db/db.php';
require_once __DIR__ . '/../jwt_utils/jwt_utils.php';

header('Content-Type: application/json');
// auth (same as others)
$headers = getallheaders(); if (empty($headers['Authorization'])) { http_response_code(401); echo json_encode(['error'=>'No token']); exit; }
$jwt = str_replace('Bearer ', '', $headers['Authorization']); $payload = validate_jwt($jwt, $jwt_secret);
if (!$payload) { http_response_code(401); echo json_encode(['error'=>'Invalid token']); exit; }

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET' && isset($_GET['member_id'])) {
    $member_id = intval($_GET['member_id']);
    $res = $conn->query("SELECT id, member_id, address_line1, address_line2, city, state, zip, country FROM member_addresses WHERE member_id=$member_id LIMIT 1");
    if ($row = $res->fetch_assoc()) echo json_encode($row);
    else echo json_encode((object)[]);
    exit;
}
if ($method === 'POST') {
    $data = json_decode(file_get_contents("php://input"), true);
    $member_id = intval($data['member_id'] ?? 0);
    $a1 = $conn->real_escape_string($data['address_line1'] ?? '');
    $a2 = $conn->real_escape_string($data['address_line2'] ?? '');
    $city = $conn->real_escape_string($data['city'] ?? '');
    $state = $conn->real_escape_string($data['state'] ?? '');
    $zip = $conn->real_escape_string($data['zip'] ?? '');
    $country = $conn->real_escape_string($data['country'] ?? '');

    $sql = "INSERT INTO member_addresses (member_id, address_line1, address_line2, city, state, zip, country) VALUES ($member_id, '$a1', '$a2', '$city', '$state', '$zip', '$country')";
    if ($conn->query($sql)) echo json_encode(['success'=>true, 'id'=>$conn->insert_id]); else echo json_encode(['error'=>$conn->error]);
    exit;
}
if ($method === 'PUT' && isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $data = json_decode(file_get_contents("php://input"), true);
    $a1 = $conn->real_escape_string($data['address_line1'] ?? '');
    $a2 = $conn->real_escape_string($data['address_line2'] ?? '');
    $city = $conn->real_escape_string($data['city'] ?? '');
    $state = $conn->real_escape_string($data['state'] ?? '');
    $zip = $conn->real_escape_string($data['zip'] ?? '');
    $country = $conn->real_escape_string($data['country'] ?? '');
    $sql = "UPDATE member_addresses SET address_line1='$a1', address_line2='$a2', city='$city', state='$state', zip='$zip', country='$country' WHERE id=$id";
    if ($conn->query($sql)) echo json_encode(['success'=>true]); else echo json_encode(['error'=>$conn->error]);
    exit;
}
http_response_code(400);
echo json_encode(['error'=>'Invalid request']);
