<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../db/db.php';
require_once __DIR__ . '/../jwt_utils/jwt_utils.php';

header("Content-Type: application/json");

// -----------------------------------------
// AUTH CHECK
// -----------------------------------------
$headers = getallheaders();

if (empty($headers['Authorization'])) {
    http_response_code(401);
    echo json_encode(["error" => "No token"]);
    exit;
}

$jwt = str_replace("Bearer ", "", $headers["Authorization"]);
$payload = validate_jwt($jwt, $jwt_secret);

if (!$payload || !isset($payload["id"])) {
    http_response_code(401);
    echo json_encode(["error" => "Invalid token"]);
    exit;
}


require_once __DIR__ . '/access.php';

// IMPORTANT: Fetch user's role_id from JWT
$current_role_id = intval($payload["role_id"]);

$method = $_SERVER["REQUEST_METHOD"];

// -----------------------------------------
// GET ALL MEMBERS
// -----------------------------------------
if ($method === "GET" && ($_GET["action"] ?? "") === "list") {

    
    check_access($conn, $current_role_id, "roles", "view");

    $status = $_GET["status"] ?? "active";

$where = "WHERE 1";

if ($status === "active") {
    $where = "WHERE isActive = 1";
} elseif ($status === "inactive") {
    $where = "WHERE isActive = 0";
}

$sql = "SELECT id, name, dob, anniversary, notes, photo_url, created_at, isActive
        FROM members 
        $where
        ORDER BY id DESC";


    $result = $conn->query($sql);
    $members = [];

    while ($row = $result->fetch_assoc()) {
        $member_id = intval($row["id"]);

        // Phones
        $phones = [];
        $pRes = $conn->query("SELECT id, phone_number, type, is_main 
                              FROM member_phones WHERE member_id=$member_id");
        while ($p = $pRes->fetch_assoc()) $phones[] = $p;
        $row["phones"] = $phones;

        // Role
        $rRes = $conn->query("
            SELECT r.name 
            FROM members_roles mr 
            JOIN roles r ON r.id = mr.role_id
            WHERE mr.member_id = $member_id LIMIT 1
        ");
        $rRow = $rRes->fetch_assoc();
        $row["role"] = $rRow["name"] ?? "Member";

        $members[] = $row;
    }

    echo json_encode($members);
    exit;
}

// -----------------------------------------
// GET SINGLE MEMBER
// -----------------------------------------
if ($method === "GET" && isset($_GET["id"])) {

    check_access($conn, $current_role_id, "roles", "view");

    $id = intval($_GET["id"]);

    $res = $conn->query("
        SELECT id, name, dob, anniversary, notes, photo_url, created_at, isActive 
        FROM members WHERE id=$id LIMIT 1
    ");

    if (!$m = $res->fetch_assoc()) {
        echo json_encode(["error" => "Member not found"]);
        exit;
    }

    // Phones
    $phones = [];
    $pRes = $conn->query("SELECT id, phone_number, type, is_main 
                          FROM member_phones WHERE member_id=$id");
    while ($p = $pRes->fetch_assoc()) $phones[] = $p;
    $m["phones"] = $phones;

    // Role
    $rRes = $conn->query("
        SELECT r.name 
        FROM members_roles mr 
        JOIN roles r ON r.id = mr.role_id
        WHERE mr.member_id=$id LIMIT 1
    ");
    $rRow = $rRes->fetch_assoc();
    $m["role"] = $rRow["name"] ?? "Member";

    echo json_encode($m);
    exit;
}

// -----------------------------------------
// CREATE MEMBER
// -----------------------------------------
if ($method === "POST" && !isset($_GET["id"])) {

    
    // Require add + edit permission
    check_access($conn, $current_role_id, "roles", "view");
    check_access($conn, $current_role_id, "roles", "add");

    $input = json_decode(file_get_contents("php://input"), true);

    $name = $conn->real_escape_string($input["name"] ?? "");
    $main_phone = $conn->real_escape_string($input["main_phone"] ?? "");

    if ($name === "" || $main_phone === "") {
        echo json_encode(["error" => "Name & phone required"]);
        exit;
    }

    $conn->begin_transaction();

    try {
        // Create member
        $conn->query("
            INSERT INTO members (name, notes, created_at)
            VALUES ('$name', '', NOW())
        ");
        $member_id = $conn->insert_id;

        // Phone
        $conn->query("
            INSERT INTO member_phones (member_id, phone_number, type, is_main)
            VALUES ($member_id, '$main_phone', 'Mobile', 1)
        ");

        // Default role = Member
        $roleQ = $conn->query("SELECT id FROM roles WHERE name='Member' LIMIT 1");
        $roleRow = $roleQ->fetch_assoc();
        $roleId = $roleRow["id"] ?? 0;

        if ($roleId > 0) {
            $conn->query("
                INSERT INTO members_roles (member_id, role_id)
                VALUES ($member_id, $roleId)
            ");
        }

        $conn->commit();
        echo json_encode(["success" => true, "id" => $member_id]);

    } catch (Exception $e) {
        $conn->rollback();
        echo json_encode(["error" => $e->getMessage()]);
    }

    exit;
}

// -----------------------------------------
// ACTIVATE MEMBER (isActive = 1)
// -----------------------------------------
if ($method === "PUT" && isset($_GET["id"]) && ($_GET["action"] ?? "") === "activate") {

    check_access($conn, $current_role_id, "roles", "view");
    check_access($conn, $current_role_id, "roles", "edit");

    $id = intval($_GET["id"]);

    $sql = "UPDATE members SET isActive = 1, updated_at = NOW() WHERE id=$id";

    if ($conn->query($sql)) {
        echo json_encode(["success" => true, "message" => "Member reactivated"]);
    } else {
        echo json_encode(["error" => $conn->error]);
    }
    exit;
}


// -----------------------------------------
// UPDATE MEMBER (ONLY when NOT updating phone)
// -----------------------------------------
if ($method === "PUT" && isset($_GET["id"]) && !isset($_GET["phone_id"])) {

    
    // Require add + edit permission
    check_access($conn, $current_role_id, "roles", "view");
    check_access($conn, $current_role_id, "roles", "edit");
    check_access($conn, $current_role_id, "roles", "add");

    $id = intval($_GET["id"]);
    $input = json_decode(file_get_contents("php://input"), true);

    $name = $conn->real_escape_string($input["name"] ?? "");
    $dob = $conn->real_escape_string($input["dob"] ?? "");
    $ann = $conn->real_escape_string($input["anniversary"] ?? "");
    $notes = $conn->real_escape_string($input["notes"] ?? "");
    $photo_url = $conn->real_escape_string($input["photo_url"] ?? "");

    $sql = "
        UPDATE members SET 
            name = '$name',
            dob = " . ($dob ? "'$dob'" : "NULL") . ",
            anniversary = " . ($ann ? "'$ann'" : "NULL") . ",
            notes = '$notes',
            photo_url = '$photo_url',
            updated_at = NOW()
        WHERE id = $id
    ";

    if ($conn->query($sql)) {
        echo json_encode(["success" => true]);
    } else {
        echo json_encode(["error" => $conn->error]);
    }
    exit;
}

// -----------------------------------------
// SOFT DELETE MEMBER (Deactivate)
// -----------------------------------------
if ($method === "DELETE" && isset($_GET["id"]) && !isset($_GET["phone_id"])) {

    // Require add + edit permission
    check_access($conn, $current_role_id, "roles", "view");
    check_access($conn, $current_role_id, "roles", "edit");
    check_access($conn, $current_role_id, "roles", "add");

    $id = intval($_GET["id"]);

    $sql = "UPDATE members SET isActive = 0, updated_at = NOW() WHERE id=$id";

    if ($conn->query($sql)) {
        echo json_encode(["success" => true, "message" => "Member deactivated"]);
    } else {
        echo json_encode(["error" => $conn->error]);
    }
    exit;
}




// -----------------------------------------
// ADD PHONE
// -----------------------------------------
if ($method === "POST" && isset($_GET["id"]) && isset($_GET["add_phone"])) {

    
    // Require add + edit permission
    check_access($conn, $current_role_id, "roles", "view");
    check_access($conn, $current_role_id, "roles", "edit");
    check_access($conn, $current_role_id, "roles", "add");

    $id = intval($_GET["id"]);
    $input = json_decode(file_get_contents("php://input"), true);

    $phone = $conn->real_escape_string($input["phone_number"]);
    $type = $conn->real_escape_string($input["type"]);
    $is_main = intval($input["is_main"]);

    if ($is_main === 1) {
        $conn->query("UPDATE member_phones SET is_main=0 WHERE member_id=$id");
    }

    $conn->query("
        INSERT INTO member_phones (member_id, phone_number, type, is_main)
        VALUES ($id, '$phone', '$type', $is_main)
    ");

    echo json_encode(["success" => true]);
    exit;
}

// -----------------------------------------
// UPDATE PHONE
// -----------------------------------------
if ($method === "PUT" && isset($_GET["id"]) && isset($_GET["phone_id"])) {

    
    // Require add + edit permission
    check_access($conn, $current_role_id, "roles", "view");
    check_access($conn, $current_role_id, "roles", "edit");
    check_access($conn, $current_role_id, "roles", "add");

    $id = intval($_GET["id"]);
    $phone_id = intval($_GET["phone_id"]);

    $input = json_decode(file_get_contents("php://input"), true);

    $phone = $conn->real_escape_string($input["phone_number"]);
    $type = $conn->real_escape_string($input["type"]);
    $is_main = intval($input["is_main"]);

    if ($is_main === 1) {
        $conn->query("UPDATE member_phones SET is_main=0 WHERE member_id=$id");
    }

    $conn->query("
        UPDATE member_phones 
        SET phone_number='$phone', type='$type', is_main=$is_main
        WHERE id=$phone_id AND member_id=$id
    ");

    echo json_encode(["success" => true]);
    exit;
}

// -----------------------------------------
// DELETE PHONE
// -----------------------------------------
if ($method === "DELETE" && isset($_GET["id"]) && isset($_GET["phone_id"])) {

    
    // Require add + edit permission
    check_access($conn, $current_role_id, "roles", "view");
    check_access($conn, $current_role_id, "roles", "edit");
    check_access($conn, $current_role_id, "roles", "add");

    $id = intval($_GET["id"]);
    $phone_id = intval($_GET["phone_id"]);

    $conn->query("DELETE FROM member_phones WHERE id=$phone_id AND member_id=$id");

    echo json_encode(["success" => true]);
    exit;
}

echo json_encode(["error" => "Invalid request"]);
exit;

?>
