<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, DELETE, OPTIONS");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') exit();

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../db/db.php';
require_once __DIR__ . '/../jwt_utils/jwt_utils.php';

$headers = getallheaders();

if (empty($headers['Authorization'])) {
    http_response_code(401);
    echo json_encode(['error' => 'No token']);
    exit;
}

$jwt = str_replace('Bearer ', '', $headers['Authorization']);
$payload = validate_jwt($jwt, $jwt_secret);

if (!$payload) {
    http_response_code(401);
    echo json_encode(['error' => 'Invalid token']);
    exit;
}

$method = $_SERVER['REQUEST_METHOD'];

/* GET ROLES OF MEMBER */
if ($method === 'GET' && isset($_GET['member_id'])) {

    $member_id = intval($_GET['member_id']);

    $sql = "
        SELECT r.id, r.name, mr.id as map_id 
        FROM members_roles mr
        JOIN roles r ON r.id = mr.role_id
        WHERE mr.member_id = $member_id
    ";

    $res = $conn->query($sql);
    $out = [];
    while ($row = $res->fetch_assoc()) $out[] = $row;

    echo json_encode($out);
    exit;
}

/* ASSIGN ROLE */
if ($method === 'POST') {
    $input = json_decode(file_get_contents("php://input"), true);

    $member_id = intval($input['member_id']);
    $role_id = intval($input['role_id']);

    $conn->query("INSERT INTO members_roles (member_id, role_id) VALUES ($member_id, $role_id)");

    echo json_encode(['success' => true]);
    exit;
}

/* REMOVE ROLE */
if ($method === 'DELETE' && isset($_GET['map_id'])) {
    $map_id = intval($_GET['map_id']);
    $conn->query("DELETE FROM members_roles WHERE id=$map_id");

    echo json_encode(['success' => true]);
    exit;
}

echo json_encode(['error' => 'Invalid request']);
