<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../db/db.php';
require_once __DIR__ . '/../jwt_utils/jwt_utils.php';

header("Content-Type: application/json");

$headers = getallheaders();
$method  = $_SERVER['REQUEST_METHOD'];

// -----------------------------
// JWT AUTH
// -----------------------------
if (empty($headers['Authorization'])) {
    http_response_code(401);
    echo json_encode(['error' => 'No token']);
    exit;
}

$jwt = str_replace("Bearer ", "", $headers['Authorization']);
$payload = validate_jwt($jwt, $jwt_secret);

if (!$payload || !isset($payload['id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Invalid token']);
    exit;
}

$user_id = intval($payload['id']);

// -----------------------------
// DB CONNECTION
// -----------------------------
if (!isset($conn)) {
    if (class_exists('Database')) {
        $dbObj = new Database();
        $conn  = $dbObj->getConnection();
    }
}

if (!$conn) {
    echo json_encode(['error' => 'DB connection error']);
    exit;
}

//
// 1. GET LATEST 10 NOTIFICATIONS FOR USER
//
if ($method === "GET" && isset($_GET['action']) && $_GET['action'] === "latest") {

    $sql = "SELECT id, member_id, message, is_read, created_at
            FROM notifications
            ORDER BY created_at DESC
            LIMIT 5";

    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $res = $stmt->get_result();

    $data = [];
    while ($row = $res->fetch_assoc()) {
        $data[] = $row;
    }

    echo json_encode($data);
    exit;
}

//
// 2. GET ALL NOTIFICATIONS FOR USER
//
if ($method === "GET" && isset($_GET['action']) && $_GET['action'] === "all") {

    $sql = "SELECT id, member_id, message, is_read, created_at
            FROM notifications
            WHERE member_id = ?
            ORDER BY created_at DESC";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $res = $stmt->get_result();

    $data = [];
    while ($row = $res->fetch_assoc()) {
        $data[] = $row;
    }

    echo json_encode($data);
    exit;
}

//
// 3. ADD NOTIFICATION
// Body example:
// { "member_id": 6, "message": "Your booking was approved" }
//
// If member_id missing → send to ALL members
//
if ($method === "POST" && isset($_GET['action']) && $_GET['action'] === "add") {

    $input = json_decode(file_get_contents("php://input"), true);

    $member_id = intval($input['member_id'] ?? 0);
    $message   = $conn->real_escape_string($input['message'] ?? '');

    if ($message === "") {
        echo json_encode(['error' => 'Message required']);
        exit;
    }

    // If member_id = 0 → send to ALL members
    if ($member_id === 0) {
        $sql = "INSERT INTO notifications (member_id, message, is_read, created_at)
                SELECT id, '$message', 0, NOW() FROM members";
        if ($conn->query($sql)) {
            echo json_encode(['success' => true, 'broadcast' => true]);
        } else {
            echo json_encode(['error' => $conn->error]);
        }
        exit;
    }

    // Else → send to specific member
    $sql = "INSERT INTO notifications (member_id, message, is_read, created_at)
            VALUES ($member_id, '$message', 0, NOW())";

    if ($conn->query($sql)) {
        echo json_encode(['success' => true, 'id' => $conn->insert_id]);
    } else {
        echo json_encode(['error' => $conn->error]);
    }
    exit;
}

//
// 4. MARK AS READ
// Body: { "id": 15 }
//
if ($method === "POST" && isset($_GET['action']) && $_GET['action'] === "read") {

    $input = json_decode(file_get_contents("php://input"), true);
    $id = intval($input['id'] ?? 0);

    if ($id <= 0) {
        echo json_encode(['error' => 'Invalid ID']);
        exit;
    }

    $sql = "UPDATE notifications SET is_read = 1 WHERE id = ? AND member_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $id, $user_id);

    if ($stmt->execute()) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['error' => $stmt->error]);
    }

    exit;
}

//
// FALLBACK
//
http_response_code(400);
echo json_encode(['error' => 'Invalid request']);
exit;

?>
