<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../db/db.php';
require_once __DIR__ . '/../jwt_utils/jwt_utils.php';

/* ------------------------------
   JWT AUTH CHECK (Same as roles)
-------------------------------- */
$headers = getallheaders();

if (empty($headers['Authorization'])) {
    http_response_code(401);
    echo json_encode(["error" => "No token provided"]);
    exit;
}

$jwt = str_replace("Bearer ", "", $headers["Authorization"]);
$payload = validate_jwt($jwt, $jwt_secret);

if (!$payload || !isset($payload["id"])) {
    http_response_code(401);
    echo json_encode(["error" => "Invalid token"]);
    exit;
}

require_once __DIR__ . '/access.php';

$current_user_id = intval($payload["id"]);
// IMPORTANT: Fetch user's role_id from JWT
$current_role_id = intval($payload["role_id"]);



/* ================================================================
   GET PERMISSIONS FOR SELECTED ROLE
   ================================================================ */
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['role_id'])) {

    check_access($conn, $current_role_id, "roles", "view");

    $role_id = intval($_GET['role_id']);

    // Get all pages (modules)
    $sql = "SELECT * FROM pages ORDER BY id ASC";
    $pages = $conn->query($sql);

    $output = [];

    while ($pg = $pages->fetch_assoc()) {

        // Check role permission for this page
        $page_key = $pg["page_key"];

        $sql2 = "SELECT * FROM role_permissions 
                 WHERE role_id = $role_id AND page_key = '$page_key' LIMIT 1";

        $perm = $conn->query($sql2)->fetch_assoc();

        $output[] = [
            "page_key"   => $page_key,
            "page_name"  => $pg["page_name"],
            "can_view"   => $perm["can_view"]   ?? 0,
            "can_add"    => $perm["can_add"]    ?? 0,
            "can_edit"   => $perm["can_edit"]   ?? 0
        ];
    }

    echo json_encode($output);
    exit;
}


/* ================================================================
   SAVE / UPDATE ROLE PERMISSIONS
   ================================================================ */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_GET['action']) && $_GET['action'] === 'save') {

    // Require add + edit permission
    check_access($conn, $current_role_id, "roles", "view");
    check_access($conn, $current_role_id, "roles", "edit");
    check_access($conn, $current_role_id, "roles", "add");


    $role_id = intval($_POST["role_id"]);
    $permissions = json_decode($_POST["permissions"], true);

    if (!$role_id || !is_array($permissions)) {
        echo json_encode(["status" => "error", "message" => "Invalid data"]);
        exit;
    }

    // Delete old permissions for role
    $conn->query("DELETE FROM role_permissions WHERE role_id = $role_id");

    // Insert new permissions
    $stmt = $conn->prepare("
        INSERT INTO role_permissions 
        (role_id, page_key, can_view, can_add, can_edit)
        VALUES (?, ?, ?, ?, ?)
    ");

    foreach ($permissions as $p) {
        $stmt->bind_param(
            "isiii",
            $role_id,
            $p["page_key"],
            $p["can_view"],
            $p["can_add"],
            $p["can_edit"]
        );
        $stmt->execute();
    }

    echo json_encode(["status" => "success"]);
    exit;
}


/* ================================================================
   INVALID REQUEST
   ================================================================ */
echo json_encode(["error" => "Invalid request"]);
exit;
?>
