<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../db/db.php';
require_once __DIR__ . '/../jwt_utils/jwt_utils.php';

/* ============================================
   JWT AUTH (Old Method - Same as slot.php)
   ============================================ */

$headers = getallheaders();

if (empty($headers['Authorization'])) {
    http_response_code(401);
    echo json_encode(["error" => "No token provided"]);
    exit;
}

$jwt = str_replace("Bearer ", "", $headers["Authorization"]);

// OLD JWT validation
$payload = validate_jwt($jwt, $jwt_secret);

if (!$payload || !isset($payload["id"])) {
    http_response_code(401);
    echo json_encode(["error" => "Invalid token"]);
    exit;
}

require_once __DIR__ . '/access.php';

$current_user_id = intval($payload["id"]);
// IMPORTANT: Fetch user's role_id from JWT
$current_role_id = intval($payload["role_id"]);


/* =============================
   GET ALL ROLES
   ============================= */
if ($_SERVER['REQUEST_METHOD'] === 'GET' && !isset($_GET['id'])) {

    check_access($conn, $current_role_id, "roles", "view");

    $sql = "SELECT * FROM roles ORDER BY id DESC";
    $result = $conn->query($sql);

    $roles = [];
    while ($row = $result->fetch_assoc()) {
        $roles[] = $row;
    }

    echo json_encode($roles);
    exit;
}

/* =============================
   GET SINGLE ROLE
   ============================= */
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['id'])) {

    check_access($conn, $current_role_id, "roles", "view");

    $id = intval($_GET['id']);
    $sql = "SELECT * FROM roles WHERE id = $id LIMIT 1";
    $res = $conn->query($sql);

    echo json_encode($res->fetch_assoc());
    exit;
}

/* =============================
   ADD ROLE
   ============================= */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_GET['id'])) {

    
    // Require add + edit permission
    check_access($conn, $current_role_id, "roles", "view");
    check_access($conn, $current_role_id, "roles", "add");

    $data = json_decode(file_get_contents("php://input"), true);
    $name = $conn->real_escape_string($data['name']);

    $sql = "INSERT INTO roles (name, is_active, created_at)
            VALUES ('$name', 1, NOW())";

    if ($conn->query($sql)) {
        echo json_encode(["success" => true, "id" => $conn->insert_id]);
    } else {
        echo json_encode(["error" => $conn->error]);
    }
    exit;
}

/* =============================
   UPDATE ROLE (PUT)
   ============================= */
if ($_SERVER['REQUEST_METHOD'] === 'PUT' && isset($_GET['id'])) {

    
    // Require add + edit permission
    check_access($conn, $current_role_id, "roles", "view");
    check_access($conn, $current_role_id, "roles", "edit");
    check_access($conn, $current_role_id, "roles", "add");

    $id = intval($_GET['id']);
    $body = json_decode(file_get_contents("php://input"), true);

    $name = isset($body['name']) ? $conn->real_escape_string($body['name']) : null;
    $is_active = isset($body['is_active']) ? intval($body['is_active']) : null;

    $set = [];
    if ($name !== null) $set[] = "name='$name'";
    if ($is_active !== null) $set[] = "is_active=$is_active";

    if (empty($set)) {
        echo json_encode(['error' => 'Nothing to update']);
        exit;
    }

    $sql = "UPDATE roles SET " . implode(", ", $set) . " WHERE id=$id";

    if ($conn->query($sql)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['error' => $conn->error]);
    }
    exit;
}

/* =============================
   UPDATE ROLE (POST ?id=1)
   ============================= */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_GET['id'])) {

    
    // Require add + edit permission
    check_access($conn, $current_role_id, "roles", "view");
    check_access($conn, $current_role_id, "roles", "edit");
    check_access($conn, $current_role_id, "roles", "add");

    $id = intval($_GET['id']);
    $data = json_decode(file_get_contents("php://input"), true);

    $name = $conn->real_escape_string($data['name']);
    $is_active = isset($data['is_active']) ? intval($data['is_active']) : 1;

    $sql = "UPDATE roles 
            SET name='$name', is_active=$is_active 
            WHERE id=$id";

    if ($conn->query($sql)) {
        echo json_encode(["success" => true]);
    } else {
        echo json_encode(["error" => $conn->error]);
    }
    exit;
}

/* =============================
   DELETE ROLE
   ============================= */
if ($_SERVER['REQUEST_METHOD'] === 'DELETE' && isset($_GET['id'])) {

    
    // Require add + edit permission
    check_access($conn, $current_role_id, "roles", "view");
    check_access($conn, $current_role_id, "roles", "edit");
    check_access($conn, $current_role_id, "roles", "add");

    $id = intval($_GET['id']);
    $sql = "DELETE FROM roles WHERE id=$id";

    if ($conn->query($sql)) {
        echo json_encode(["success" => true]);
    } else {
        echo json_encode(["error" => $conn->error]);
    }
    exit;
}

/* =============================
   INVALID REQUEST
   ============================= */
echo json_encode(["error" => "Invalid request"]);
exit;
?>
