<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../db/db.php';
require_once __DIR__ . '/../jwt_utils/jwt_utils.php';

header("Content-Type: application/json");

$headers = getallheaders();
if (empty($headers['Authorization'])) {
    http_response_code(401);
    echo json_encode(["error" => "No token"]);
    exit;
}

$jwt = str_replace("Bearer ", "", $headers['Authorization']);
$payload = validate_jwt($jwt, $jwt_secret);

if (!$payload || !isset($payload["role_id"])) {
    http_response_code(401);
    echo json_encode(["error" => "Invalid token"]);
    exit;
}

require_once __DIR__ . '/access.php';

$current_role_id = intval($payload["role_id"]);

$action = $_GET['action'] ?? '';

switch ($action) {
    case 'get':    getSlots($conn); break;
    case 'add':    addSlot($conn); break;
    case 'edit':   editSlot($conn); break;
    case 'delete': deleteSlot($conn); break;
    default:
        echo json_encode(["error" => "Invalid action"]);
}


/* ==========================================================
   FUNCTIONS
   ========================================================== */

// GET SLOTS
function getSlots($conn)
{
    global $current_role_id;
    check_access($conn, $current_role_id, "services", "view");

    $result = $conn->query("SELECT * FROM slots ORDER BY id ASC");
    $rows = [];
    while ($r = $result->fetch_assoc()) $rows[] = $r;

    echo json_encode(["status" => true, "data" => $rows]);
    exit;
}

// ADD SLOT
function addSlot($conn)
{
    global $current_role_id;
    check_access($conn, $current_role_id, "services", "add");

    $input = json_decode(file_get_contents("php://input"), true);

    if (empty($input['slot_duration']) || empty($input['price'])) {
        http_response_code(400);
        echo json_encode(["error" => "slot_duration and price required"]);
        exit;
    }

    $stmt = $conn->prepare("INSERT INTO slots (slot_duration, price) VALUES (?, ?)");
    $stmt->bind_param("si", $input['slot_duration'], $input['price']);

    if ($stmt->execute()) {
        echo json_encode(["status" => true, "slot_id" => $stmt->insert_id]);
    } else {
        echo json_encode(["error" => "Failed to add slot"]);
    }
    exit;
}

// EDIT SLOT
function editSlot($conn)
{
    global $current_role_id;
    check_access($conn, $current_role_id, "services", "edit");

    $input = json_decode(file_get_contents("php://input"), true);

    if (empty($input['id']) || empty($input['slot_duration']) || empty($input['price'])) {
        http_response_code(400);
        echo json_encode(["error" => "id, slot_duration, price required"]);
        exit;
    }

    $stmt = $conn->prepare("UPDATE slots SET slot_duration=?, price=? WHERE id=?");
    $stmt->bind_param("sii", $input['slot_duration'], $input['price'], $input['id']);

    echo $stmt->execute()
        ? json_encode(["status" => true])
        : json_encode(["error" => "Failed to update slot"]);

    exit;
}

// DELETE SLOT
function deleteSlot($conn)
{
    global $current_role_id;
    check_access($conn, $current_role_id, "services", "edit");

    $input = json_decode(file_get_contents("php://input"), true);

    if (empty($input['id'])) {
        http_response_code(400);
        echo json_encode(["error" => "id required"]);
        exit;
    }

    $stmt = $conn->prepare("DELETE FROM slots WHERE id=?");
    $stmt->bind_param("i", $input['id']);

    echo $stmt->execute()
        ? json_encode(["status" => true])
        : json_encode(["error" => "Failed to delete slot"]);

    exit;
}
?>
