<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(200); exit(); }
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../db/db.php';
require_once __DIR__ . '/../jwt_utils/jwt_utils.php';

header('Content-Type: application/json');

// Minimal auth check (optional)
$headers = getallheaders();
if (empty($headers['Authorization'])) {
    http_response_code(401); echo json_encode(['error'=>'No token']); exit;
}
$jwt = str_replace('Bearer ', '', $headers['Authorization']);
$payload = validate_jwt($jwt, $jwt_secret);
if (!$payload) { http_response_code(401); echo json_encode(['error'=>'Invalid token']); exit; }

// Upload handling
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); echo json_encode(['error'=>'Only POST']); exit;
}

if (!isset($_FILES['profile']) || $_FILES['profile']['error'] !== UPLOAD_ERR_OK) {
    echo json_encode(['error' => 'No file uploaded or upload error']); exit;
}

$file = $_FILES['profile'];
$allowed = ['image/jpeg','image/png'];
if (!in_array($file['type'], $allowed)) {
    echo json_encode(['error'=>'Invalid file type']); exit;
}
if ($file['size'] > 2 * 1024 * 1024) {
    echo json_encode(['error'=>'File too large']); exit;
}

$ext = pathinfo($file['name'], PATHINFO_EXTENSION);
$filename = time() . '_' . bin2hex(random_bytes(6)) . '.' . $ext;
$targetDir = __DIR__ . '/../../uploads/profile/';
if (!is_dir($targetDir)) mkdir($targetDir, 0755, true);
$targetPath = $targetDir . $filename;

if (!move_uploaded_file($file['tmp_name'], $targetPath)) {
    echo json_encode(['error'=>'Failed to move uploaded file']); exit;
}

// Optionally update member row - if you want to store photo_url in members table
$member_id = intval($_POST['member_id'] ?? 0);
if ($member_id) {
    $stmt = $conn->prepare("UPDATE members SET photo_url = ? WHERE id = ?");
    $stmt->bind_param('si', $filename, $member_id);
    $stmt->execute();
}

echo json_encode(['filename' => $filename]);
exit;
?>
