<?php
require_once __DIR__ . '/../vendor/autoload.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

function create_jwt($payload, $secret) {
    return JWT::encode($payload, $secret, 'HS256');
}

function validate_jwt($jwt, $secret) {
    try {
        $decoded = JWT::decode($jwt, new Key($secret, 'HS256'));
        return (array) $decoded;
    } catch (Exception $e) {
        return false;
    }
}
?>
